<?php
//
// William W. Patterson, June 2001, ailanto@kafejo.com, http://www.kafejo.com
//
// tral = translate
//
require_once("motez.php");
require_once("words.php");
function translation( $sourcelanguage, $yourword )
   {
   global $motez, $words;
   if ( !strcmp($sourcelanguage,"Speedwords") )
      {
      if ( !strcmp($yourword,"&amp;") ) return "and";
      if ( !strcmp($yourword,"&amp;e") ) return "et cetera";
      if ( isset($motez[$yourword]) ) return $motez[$yourword];
      $myword = strtolower($yourword);
      if ( isset($motez[$myword]) ) return $motez[$myword];
      }
   if ( !strcmp($sourcelanguage,"English") )
      {
      if ( !strcmp($yourword,"and") ) return "&amp;";
      if ( !strcmp($yourword,"etcetera") ) return "&amp;e";
      if ( isset($words[$yourword]) ) return $words[$yourword];
      $myword = strtolower($yourword);
      if ( isset($words[$myword]) ) return $words[$myword];
      }
   return "<em>$yourword</em>";
   }
?>

<html>

<head>

   <title>tral - Speedwords/English Translator</title>
   <meta name="Description" content="translate between dutton speedwords and english">
   <style type="text/css">
      body { color: green; background-color: white }
      em { color: red; font-style: normal }
      a:link, a:visited, a:active, a:hover { text-decoration: none }
      a:link { color: blue }
      a:visited { color: #F3F }
      a:active { color: lime }
      a:hover { color: #3C3 }
      hr { color: #930; background-color: #930; border-color: #930; margin-top: 0; margin-bottom: 1em }
      h1 { color: #F90; background-color: transparent; font-size: x-large; font-family: sans-serif; font-style: italic; font-weight: bold; margin-top: 0; margin-bottom: 0 }
      div.attribution { text-align: right; font-style: italic; margin-top: 1em; margin-bottom: 1em }
   </style>
   <meta name="Keywords" content="ailanto, dutton, speedwords">
   <meta name="Generator" content="Vim">
</head>

<body>

<h1>Speedwords/English Translator</h1>
<hr>

<!--
If no action is specified for the form, this same page (base url!)
should be reloaded. But Opera 3 is broken; it loads the entire url,
*old* form variables and all, and just keeps appending the new values
to the old. Weird! Oh, well, explicitly naming myself should satisfy
everybody..
-->

<form name="myform" action="index.php">
   <table>
      <tr>
         <td align="center" valign="top" rowspan="2">
            <textarea name="mytext" rows="4" cols="40"><?php if ( isset($mytext) ) echo $mytext ?></textarea>
         </td>
         <td align="left" valign="bottom" nowrap>
            <input type="radio" name="sourcelanguage" value="Speedwords" <?php if ( ( !isset($sourcelanguage) ) || ( strcmp($sourcelanguage,"English") ) ) echo "checked" ?> >&nbsp; From Speedwords
            <br>
            <input type="radio" name="sourcelanguage" value="English" <?php if ( isset($sourcelanguage) && strcmp($sourcelanguage,"Speedwords") ) echo "checked" ?> >&nbsp; To Speedwords
         </td>
         <td align="left" valign="top" rowspan="2">
            When you press the Submit button, I will generate a list
            of your words and their translation possibilities in the
            other language. Be wary of synonyms! And generally speaking,
            affixes confuse me; Use roots!
            <p>
            <!-- <div class="attribution">2001.06.20 yfony,<br>2003.02.27 yotit.</div> -->
            <div class="attribution"><a href="http://www.kafejo.com/download/tral.zip">PHP Sourcefiles (zipped)</a></div>
         </td>
      </tr>
      <tr>
         <td align="center" valign="middle">
            <input type="submit">
         </td>
      </tr>
   </table>
</form>

<p>

<?php
if ( isset($mytext) )
   {
   $mytext = trim(urldecode($mytext));
   $mytext = str_replace("\r"," ",$mytext);
   $mytext = str_replace("\n"," ",$mytext);
   $mytext = ereg_replace("[^ A-Za-z&0-9]","",$mytext);
   $mytext = str_replace("&","&amp;",$mytext);
   $mytext = str_replace("et cetera","etcetera",$mytext);
   if ( strlen($mytext) > 0 )
      {
      $vortoj = explode(" ",$mytext);
      echo "Source language: $sourcelanguage\n";
      echo "<p>\n";
      echo "<table>\n";
      foreach ( $vortoj as $vorto )
         {
         if ( strlen($vorto) > 0 )
            {
            echo "<tr>\n";
            echo "<td>$vorto</td>\n";
            echo "<td> = " . translation($sourcelanguage,$vorto) . "</td>\n";
            echo "</tr>\n";
            }
         }
      echo "</table>\n";
      }
   }
?>

</body>

</html>

